% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastqueue2.R
\name{fastqueue2}
\alias{fastqueue2}
\alias{[[.fastqueue2}
\alias{[.fastqueue2}
\alias{print.fastqueue2}
\alias{length.fastqueue2}
\alias{as.list.fastqueue2}
\title{A Wrapper for \code{fastmap::fastqueue}}
\usage{
fastqueue2(init = 20L, missing_default = NULL)

\method{[[}{fastqueue2}(x, i)

\method{[}{fastqueue2}(x, i, j = NULL, ...)

\method{print}{fastqueue2}(x, ...)

\method{length}{fastqueue2}(x)

\method{as.list}{fastqueue2}(x, ...)
}
\arguments{
\item{init, missing_default}{passed to \code{fastmap::fastqueue}}

\item{x}{a \code{'fastqueue2'} object}

\item{i, j}{integer index}

\item{...}{integer indices or passed to other methods}
}
\value{
A list of \code{'fastqueue2'} instance
}
\description{
A Wrapper for \code{fastmap::fastqueue}
}
\examples{

x <- fastqueue2()

# add elements
x$madd(1, "b", function(){ "c" }, 4, "5")

# print information
print(x)

# get the second element without changing the queue
x[[2]]

# remove and get the first element
x$remove()

# the second item
x[[2]]

# first two items in a list
x[c(1,2)]

print(x)
as.list(x)

}
