% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{is_from_namespace}
\alias{is_from_namespace}
\title{Check whether a function, environment comes from a namespace}
\usage{
is_from_namespace(x, recursive = TRUE)
}
\arguments{
\item{x}{function, environment, language (with environment attached)}

\item{recursive}{whether to recursively search parent environments}
}
\value{
logical true if \code{x} or its environment is
defined in a namespace; returns false if the object is atomic, or defined
in/from global environment, or an empty environment.
}
\description{
A coarse way to find if a function comes from a package.
}
\examples{


is_from_namespace(baseenv())        # TRUE
is_from_namespace(utils::read.csv)  # TRUE

x <- function(){}
is_from_namespace(NULL)             # FALSE
is_from_namespace(x)                # FALSE
is_from_namespace(emptyenv())       # FALSE

# Let environment of `x` be base environment
# (exception case)
environment(x) <- baseenv()
is_from_namespace(x)        # TRUE


}
