% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topics.R
\name{topics}
\alias{topic}
\alias{topic_create}
\alias{topic_delete}
\alias{topic_rename}
\alias{topics}
\alias{topics_by}
\alias{topics_latest}
\alias{topics_new}
\title{Work with topics}
\usage{
topics_latest(url = NULL, key = NULL, user = NULL, ...)

topics_new(url = NULL, key = NULL, user = NULL, ...)

topics_by(id, url = NULL, key = NULL, user = NULL, ...)

topic(id, url = NULL, key = NULL, user = NULL, ...)

topic_create(title, text, category = NULL, url = NULL, key = NULL,
  user = NULL, ...)

topic_delete(id, url = NULL, key = NULL, user = NULL, ...)

topic_rename(id, title, url = NULL, key = NULL, user = NULL, ...)
}
\arguments{
\item{url}{Base url for a Discourse installation. See \code{\link{disc_setup}}}

\item{key}{Your api key on the Discourse installation. See \code{\link{disc_setup}}}

\item{user}{Your user name on the Discourse installation. See \code{\link{disc_setup}}}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}},
\code{\link[httr]{POST}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{id}{A user identifier, or a topic identifier. See examples.}

\item{title}{Title of the new topic}

\item{text}{Raw text, can include markdown and will be rendered.}

\item{category}{Category to apply to topic, if any, Default: none}
}
\description{
Work with topics
}
\examples{
\dontrun{
topics_latest()
topics_new()
topics_by("cboettig")
topic(8)

library("httr")
topics_latest(config=verbose())

# Create topic
## simple
topic_create(title="testing from discgolf - 1", text="testing from discgolf, hello world!
hopefully this works")

## more complicated
text <- '
## this time with markdown

```r
print("hello world")
#> [1] "hello world"
```

```r
head(mtcars)
#>                    mpg cyl disp  hp drat    wt  qsec vs am gear carb
#> Mazda RX4         21.0   6  160 110 3.90 2.620 16.46  0  1    4    4
#> Mazda RX4 Wag     21.0   6  160 110 3.90 2.875 17.02  0  1    4    4
#> Datsun 710        22.8   4  108  93 3.85 2.320 18.61  1  1    4    1
#> Hornet 4 Drive    21.4   6  258 110 3.08 3.215 19.44  1  0    3    1
#> Hornet Sportabout 18.7   8  360 175 3.15 3.440 17.02  0  0    3    2
#> Valiant           18.1   6  225 105 2.76 3.460 20.22  1  0    3    1
```
'
topic_create(title="testing from discgolf - 2", text=text)

# delete a topic
topic_delete(242)


# rename a topic - DOESN'T WORK YET
## create a topic
# res <- topic_create(title = "testing from discgolf - 5",
#    text = "testing from discgolf, again")
## rename
# res$topic_slug
# topic_rename(res$topic_id, title = "new title")
# topic(res$topic_id)$title
## cleanup
# topic_delete(res$topic_id)
}
}

