% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2023-04-24_DisclosuR.R
\name{newswire_segmenter_folder}
\alias{newswire_segmenter_folder}
\title{Newswire segmenter (multiple files)}
\usage{
newswire_segmenter_folder(
  folder_path,
  sentiment = FALSE,
  emotion = FALSE,
  regulatory_focus = FALSE,
  laughter = FALSE,
  narcissism = FALSE,
  text_clustering = FALSE
)
}
\arguments{
\item{folder_path}{The path to the folder in which the 'newswire' PDFs reside.
If it does not contain an absolute path, the folder name is
relative to the current working directory, getwd().}

\item{sentiment}{Performs dictionary-based sentiment analysis
based on the \code{\link[SentimentAnalysis]{analyzeSentiment}}
function (default: FALSE)}

\item{emotion}{Performs dictionary-based emotion analysis based on the
\code{\link[syuzhet]{get_nrc_sentiment}} function (default: FALSE)}

\item{regulatory_focus}{Calculates the number of words indicative for
promotion and prevention focus based on the
dictionary developed by \href{https://psycnet.apa.org/record/2015-41859-013}{Gamache et al., 2015}
(default: FALSE)}

\item{laughter}{Counts the number of times laughter was indicated in a quote. (default: FALSE)}

\item{narcissism}{Counts the number of pronoun usage and calculates the ratio of first-person singular to
first-person plural pronouns. This measure is derived from \href{https://psycnet.apa.org/record/2015-06474-002}{Zhu & Chen, (2015}
(default: FALSE)}

\item{text_clustering}{Applies a document categorization using a dictionary developed based on the framework developed by \href{https://escholarship.org/uc/item/026179rh}{Graffin et al., 2016}. (default: FALSE)}
}
\value{
An R data frame with each row representing one 'newswire' article. The columns indicate the title, text,
'newswire', date, and weekday. (default: FALSE)

An R data frame with each row representing one 'newswire' article. The columns indicate the title, text,
'newswire', date, and weekday. Depending on the additional arguments, the output data can also
contain sentiment, emotion, regulatory focus, laughter, narcissism and text cluster based on the Graffin et al.
categories.
}
\description{
Takes all PDF documents in a folder containing 'newswire' documents obtained from 'NexisUni' and transforms them into
an R data frame consisting of one row per document.
}
\examples{
newswire_df <- newswire_segmenter_folder(
folder_path = system.file("inst",
"examples",
"newswire",
package = "disclosuR"));
newswire_df_sentiment <- newswire_segmenter_folder(
folder_path = system.file("inst",
"examples",
"newswire",
package = "dislosuR"), sentiment = TRUE);

}
