% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disco.R
\name{makeSummary}
\alias{makeSummary}
\title{Common modules in specified comparisons}
\usage{
makeSummary(...)
}
\arguments{
\item{...}{any number of data frames created as a result of tmodCERNOtest functions}
}
\value{
list of two elements: RowN - list, each element of it contains number of rows in every subsequent comparison, 
int character vector with IDs of all modules belonging to the intersection of comparisons provided as the input
}
\description{
Summarize numbers of enriched modules in an unrestricted number of comparisons and list all the modules that belong to intersection of specified comparisons.
}
\examples{
library(tmod)
data(tmod)
data(orthologs)
disco <- disco.score(orthologs)
g <- toupper(orthologs$genes)
concordant <- tmodCERNOtest(g[order(disco, decreasing = TRUE)])
discordant <- tmodCERNOtest(g[order(disco)])
sum1 <- makeSummary(concordant, discordant)
}
