% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq_2sls.R
\docType{class}
\name{eq_2sls-class}
\alias{eq_2sls-class}
\title{Equilibrium model estimated using 2-stage least squares.}
\description{
In the first stage, prices are regressed on remaining controls from both the
demand and supply equations. In the second stage, the demand and supply equation is estimated
using the fitted prices instead of the observed. A necessary identification condition is that
there is at least one control that is exclusively part of the demand and one control
that is exclusively part of the supply equation.

\deqn{D_{nt} = X_{d,nt}'\beta_{d} + P_{nt}\alpha_{d} + u_{d,nt},}
\deqn{S_{nt} = X_{s,nt}'\beta_{s} + P_{nt}\alpha_{s} + u_{s,nt},}
\deqn{Q_{nt} = D_{nt} = S_{nt}.}
}
\section{Slots}{

\describe{
\item{\code{first_stage_model}}{An estimated first stage equation of type \code{\link[stats]{lm}}.}

\item{\code{system_model}}{An estimated system of market equations of type
\code{\link[systemfit]{systemfit}}.}
}}

\examples{
simulated_data <- simulate_model_data(
  "eq_2sls", 500, 3, # model type, observed entities and time points
  -0.9, 14.9, c(0.3, -0.2), c(-0.03, -0.01), # demand coefficients
  0.9, 3.2, c(0.3), c(0.5, 0.02) # supply coefficients
)

# initialize the model
model <- new(
  "eq_2sls", # model type
  c("id", "date"), "Q", "P", # keys, quantity, and price variables
  "P + Xd1 + Xd2 + X1 + X2", "P + Xs1 + X1 + X2", # equation specifications
  simulated_data # data
)
}
