% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R
\name{plot,market_model,ANY-method}
\alias{plot,market_model,ANY-method}
\title{Plots the model.}
\usage{
\S4method{plot}{market_model,ANY}(x)
}
\arguments{
\item{x}{A model object.}
}
\description{
Displays a graphical illustration of the passed model object.
}
\examples{
\donttest{
simulated_data <- simulate_model_data(
    "diseq_basic", 500, 3, # model type, observed entities, observed time points
    -0.9, 8.9, c(0.03, -0.02), c(-0.03, -0.01), # demand coefficients
    0.9, 4.2, c(0.03), c(0.05, 0.02), # supply coefficients
)

# initialize the model
model <- new(
    "diseq_basic", # model type
    c("id", "date"), "Q", "P", # keys, time, quantity, and price variables
    "P + Xd1 + Xd2 + X1 + X2", "P + Xs1 + X1 + X2", # equation specifications
    simulated_data, # data
    use_correlated_shocks = TRUE # allow shocks to be correlated
)

# print the model
plot(model)
}
}
