% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R
\name{market_quantities}
\alias{market_quantities}
\alias{demanded_quantities}
\alias{demanded_quantities,market_model-method}
\alias{supplied_quantities}
\alias{supplied_quantities,market_model-method}
\title{Estimated market quantities.}
\usage{
demanded_quantities(object, parameters)

\S4method{demanded_quantities}{market_model}(object, parameters)

supplied_quantities(object, parameters)

\S4method{supplied_quantities}{market_model}(object, parameters)
}
\arguments{
\item{object}{A model object.}

\item{parameters}{A vector of model's parameters.}
}
\value{
A vector with the demanded quantities evaluated at the given parameter
vector.
}
\description{
Estimated market quantities.
}
\details{
Calculates and returns the estimated demanded or supplied quantities for
each observation at the passed vector of parameters.
}
\section{Functions}{
\itemize{
\item \code{demanded_quantities}: Estimated demanded quantities.

\item \code{supplied_quantities}: Estimated supplied quantities.
}}

\examples{
\donttest{
# initialize the model using the houses dataset
model <- new(
  "diseq_basic", # model type
  c("ID", "TREND"), "HS", "RM", # keys, quantity, and price variables
  "RM + TREND + W + CSHS + L1RM + L2RM + MONTH", # demand specification
  "RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH", # supply specification
  fair_houses(), # data
  correlated_shocks = FALSE # allow shocks to be correlated
)

# estimate the model object (BFGS is used by default)
est <- estimate(model)

# get estimated demanded and supplied quantities
head(cbind(demanded_quantities(model, est@coef),
     supplied_quantities(model, est@coef)))
}
}
