% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hard_arrange.r
\name{hard_arrange}
\alias{hard_arrange}
\alias{hard_arrange.data.frame}
\alias{hard_arrange.disk.frame}
\title{Perform a hard arrange}
\usage{
hard_arrange(df, ..., add = FALSE, .drop = FALSE)

\method{hard_arrange}{data.frame}(df, ...)

\method{hard_arrange}{disk.frame}(
  df,
  ...,
  outdir = tempfile("tmp_disk_frame_hard_arrange"),
  nchunks = disk.frame::nchunks(df),
  overwrite = TRUE
)
}
\arguments{
\item{df}{a disk.frame}

\item{...}{grouping variables}

\item{add}{same as dplyr::arrange}

\item{.drop}{same as dplyr::arrange}

\item{outdir}{the output directory}

\item{nchunks}{The number of chunks in the output. Defaults = nchunks.disk.frame(df)}

\item{overwrite}{overwrite the out put directory}
}
\description{
A hard_arrange is a sort by that also reorganizes the chunks to ensure that
every unique grouping of `by`` is in the same chunk. Or in other words, every
row that share the same `by` value will end up in the same chunk.
}
\examples{
iris.df = as.disk.frame(iris, nchunks = 2)

# arrange iris.df by specifies and ensure rows with the same specifies are in the same chunk
iris_hard.df = hard_arrange(iris.df, Species)

get_chunk(iris_hard.df, 1)
get_chunk(iris_hard.df, 2)

# clean up cars.df
delete(iris.df)
delete(iris_hard.df)
}
