% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chrono.subsets.R
\name{chrono.subsets}
\alias{chrono.subsets}
\alias{time.series}
\alias{time.subsets}
\title{Separating data in chronological subsets.}
\usage{
chrono.subsets(
  data,
  tree,
  method,
  time,
  model,
  inc.nodes = FALSE,
  FADLAD,
  verbose = FALSE,
  t0 = FALSE,
  bind.data = FALSE
)
}
\arguments{
\item{data}{A \code{matrix} or a \code{list} of matrices.}

\item{tree}{A \code{phylo} or a \code{multiPhylo} object matching the data and with a \code{root.time} element. This argument can be left missing if \code{method = "discrete"} and all elements are present in the optional \code{FADLAD} argument.}

\item{method}{The time subsampling method: either \code{"discrete"} (or \code{"d"}) or \code{"continuous"} (or \code{"c"}).}

\item{time}{Either a single \code{integer} for the number of discrete or continuous samples or a \code{vector} containing the age of each sample.}

\item{model}{One of the following models: \code{"acctran"}, \code{"deltran"}, \code{"random"}, \code{"proximity"}, \code{"equal.split"} or \code{"gradual.split"}. Is ignored if \code{method = "discrete"}.}

\item{inc.nodes}{A \code{logical} value indicating whether nodes should be included in the time subsets. Is ignored if \code{method = "continuous"}.}

\item{FADLAD}{An optional \code{data.frame} containing the first and last occurrence data.}

\item{verbose}{A \code{logical} value indicating whether to be verbose or not. Is ignored if \code{method = "discrete"}.}

\item{t0}{If \code{time} is a number of samples, whether to start the sampling from the \code{tree$root.time} (\code{TRUE}), or from the first sample containing at least three elements (\code{FALSE} - default) or from a fixed time point (if \code{t0} is a single \code{numeric} value).}

\item{bind.data}{If \code{data} contains multiple matrices and \code{tree} contains the same number of trees, whether to bind the pairs of matrices and the trees (\code{TRUE}) or not (\code{FALSE} - default).}
}
\description{
Splits the data into a chronological (time) subsets list.
}
\details{
The data is considered as the multidimensional space with rows as elements and columns as dimensions and is not transformed (e.g. if ordinated with negative eigen values, no correction is applied to the matrix).

If \code{method = "continuous"} and when the sampling is done along an edge of the tree, the data selected for the time subsets can be one of the following:
\itemize{
     \item Punctuated models:
     \itemize{
        \item \code{"acctran"}: always selecting the value from the ancestral node.
        \item \code{"deltran"}: always selecting the value from the descendant node or tip.
        \item \code{"random"}: randomly selecting between the ancestral node or the descendant node/tip.
        \item \code{"proximity"}: selecting the ancestral node or the descendant node/tip with a probability relative to branch length.
     }
     \item Gradual models:
     \itemize{
         \item \code{"equal.split"}: randomly selecting from the ancestral node or the descendant node or tip with a 50\% probability each.
         \item \code{"gradual.split"}: selecting the ancestral node or the descendant with a probability relative to branch length.
     }
}
N.B. \code{"equal.split"} and \code{"gradual.split"} differ from the punctuated models by outputting a node/tip probability table rather than simply the node and the tip selected. In other words, when bootstrapping using \code{\link{boot.matrix}}, the two former models will properly integrate the probability to the bootstrap procedure (i.e. different tips/nodes can be drawn) and the two latter models will only use the one node/tip determined by the model before the bootstrapping.
}
\examples{
## Load the Beck & Lee 2014 data
data(BeckLee_tree) ; data(BeckLee_mat50)
data(BeckLee_mat99) ; data(BeckLee_ages)

## Time binning (discrete method)
## Generate two discrete time bins from 120 to 40 Ma every 40 Ma
chrono.subsets(data = BeckLee_mat50, tree = BeckLee_tree, method = "discrete",
     time = c(120, 80, 40), inc.nodes = FALSE, FADLAD = BeckLee_ages)
## Generate the same time bins but including nodes
chrono.subsets(data = BeckLee_mat99, tree = BeckLee_tree, method = "discrete",
     time = c(120, 80, 40), inc.nodes = TRUE, FADLAD = BeckLee_ages)

## Time slicing (continuous method)
## Generate five equidistant time slices in the dataset assuming a proximity
## evolutionary model
chrono.subsets(data = BeckLee_mat99, tree = BeckLee_tree,
     method = "continuous", model = "acctran", time = 5,
     FADLAD = BeckLee_ages)

}
\references{
Guillerme T. & Cooper N. \bold{2018}. Time for a rethink: time sub-sampling methods in disparity-through-time analyses. Palaeontology. DOI: 10.1111/pala.12364.
}
\seealso{
\code{\link{tree.age}}, \code{\link{slice.tree}}, \code{\link{cust.subsets}}, \code{\link{boot.matrix}}, \code{\link{dispRity}}.
}
\author{
Thomas Guillerme
}
