% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCglmm.subsets.R
\name{MCMCglmm.subsets}
\alias{MCMCglmm.subsets}
\title{MCMCglmm.subsets}
\usage{
MCMCglmm.subsets(
  data,
  posteriors,
  group,
  tree,
  rename.groups,
  set.loc = TRUE,
  ...
)
}
\arguments{
\item{data}{The \code{data.frame} or \code{matrix} used for the \code{\link[MCMCglmm]{MCMCglmm}} model.}

\item{posteriors}{A \code{\link[MCMCglmm]{MCMCglmm}} object, the posteriors of the model.}

\item{group}{Optional, a named vector of which group to include from the posteriors (if left empty the random and residual terms are used). See details.}

\item{tree}{Optional, the tree(s) used in the MCMCglmm analyses.}

\item{rename.groups}{Optional, a vector of group names for renaming them. See details.}

\item{set.loc}{Optional, if no location is available for a subset (\code{$Sol = 0}), set the location of the subset from \code{data} (the centroid of the group) (default is \code{TRUE}).}

\item{...}{Optional arguments to be passed to \code{\link{MCMCglmm.covars}}.}
}
\description{
Creating a dispRity object from a MCMCglmm posterior output
}
\details{
\itemize{
     \item For the \code{group} option, the group names must be ones found in the \code{posteriors} formula in the format \emph{<Type = Term:FactorLevel>} as returned by \code{MCMCglmm.levels(posteriors)}. For example, for returning two random effect, the phylogenetic one (\code{"animal"}) and one for a specific clade (say the 2nd clade) as well as two residual terms for a specific factor (say level 1 and 4) you can use \code{group = c(random = "animal", random = "animal:clade2", residual = "units:myfactor1", residual = "units:myfactor4")}.
     \item For the \code{rename.groups} option, the vector must be of class \code{"character"} and must of the same length as the number of random and residual terms in \code{posteriors} or of \code{group} argument (if used). If the \code{group} argument is left empty, the groups are extracted from the \code{posteriors} in the following order: the random terms first then the residual terms as specified in the \code{posteriors} object formulas (respectively \code{posteriors$Random$formula} and \code{posteriors$Residual$formula}).
}

\emph{NOTE} that the output \code{dispRity} inherits the dimensions used in the \code{posteriors} argument. You can always check the selected dimensions using:
\code{data$call$dimensions}
}
\examples{
data(charadriiformes)

## Creating a dispRity object from the charadriiformes model
MCMCglmm.subsets(data       = charadriiformes$data,
                 posteriors = charadriiformes$posteriors)

## Same but selecting only the three first random terms
MCMCglmm.subsets(data       = charadriiformes$data,
                 posteriors = charadriiformes$posteriors,
                 tree       = charadriiformes$tree,
                 group      = MCMCglmm.levels(
                                 charadriiformes$posteriors)[1:3],
                 rename.groups = c("gulls", "plovers", "sandpipers"))


}
\seealso{
\code{\link{dispRity}}  \code{\link{covar.plot}}
}
\author{
Thomas Guillerme
}
