% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{store_in_DB}
\alias{store_in_DB}
\alias{list_DB}
\alias{write_to_DB}
\alias{index_DB}
\alias{read_from_DB}
\alias{delete_from_DB}
\title{Store data in SQLite database}
\usage{
list_DB(database)

write_to_DB(
  database,
  data,
  table,
  overwrite = FALSE,
  append = FALSE,
  verbose = TRUE
)

index_DB(database, table, index.unique, index.column.name, verbose = TRUE)

read_from_DB(
  database,
  table,
  choose.columns = FALSE,
  column.names,
  select = FALSE,
  select.column.name,
  select.val,
  unique = FALSE
)

delete_from_DB(database, table, verbose = TRUE)
}
\arguments{
\item{database}{character; SQLite database name and path.}

\item{data}{data frame that should be stored as database table.}

\item{table}{character; table name.}

\item{overwrite}{logical; use \code{overwrite = TRUE} if you want to overwrite a table that already exists in database}

\item{append}{logical; append rows to table}

\item{verbose}{logical; show messages}

\item{index.unique}{logical; vector of indicators to create unique or not unique indexes}

\item{index.column.name}{vector of indexed columns' names}

\item{choose.columns}{logical; return chosen columns only}

\item{column.names}{character; vector of name of columns that are chosen to be returned}

\item{select}{logical; return only rows that contain selected values in one column}

\item{select.column.name}{character; name of column that contains selected values}

\item{select.val}{vector of values that define rows that should be returned}

\item{unique}{logical; delete duplicated rows}
}
\value{
\code{list_DB} returns character vector of names of database tables.

\code{read_from_DB} returns a data frame with the content of SQLite table.
}
\description{
Write, read and delete tables from SQLite database.
}
\details{
This functions help to store big data frames in SQLite database which makes it faster to save and read the data.

This function creates SQLlite connection to database, fulfills the task and then disconnects.
If no database has been created yet, creates one.

Do not use \code{overwrite = TRUE} if table does not exists.
Do not use \code{append = TRUE} and \code{overwrite = TRUE} at the same time, no append is possible while overwriting.

If multiple indexes are created in one table, they are unrelated.

Do not use dots in data frame character variables, use underscore.

Parameters \code{choose.columns=FALSE, column.names, select, select.column.name, select.val, unique} are only used with
link{read_from_DB} function. Those parameters define rows and columns that will be returned.
}
\section{Functions}{
\itemize{
\item \code{list_DB}: Lists all tables from SQLite database

\item \code{write_to_DB}: Writes data frame into SQLite database table

\item \code{index_DB}: Creates SQLite indexes in database table

\item \code{read_from_DB}: Reads table from SQLite database and writes it into data frame.

\item \code{delete_from_DB}: Deletes table from SQLite database.
}}

\examples{
mydata <- as.data.frame (matrix(1:10, 2, 5))
database <- tempfile()
write_to_DB (database, data = mydata, table = "table1", overwrite = FALSE)
list_DB (database)
mydata2 <- as.data.frame (matrix(11:20, 2, 5))
write_to_DB (database, data = mydata2, table = "table1", overwrite = TRUE)
mydata3 <- read_from_DB (database, table = "table1")
delete_from_DB (database, table = "table1")
file.remove (database)

# example with reading table with restricted columns and rows.
mydata <- data.frame(ids = c(1:6), titles = c("A", "B", "C", "D", "E", "E"),
                    other = rep("other", 6))
database <- tempfile()
write_to_DB (database, data = mydata, table = "table1", overwrite = FALSE)
read_from_DB(database, "table1", choose.columns = TRUE, column.names = c("ids", "titles", "other"),
            select = TRUE, select.column.name = "ids",  select.val = 3:6, unique = TRUE)
read_from_DB(database, "table1", choose.columns = TRUE, column.names = c("titles", "other"),
            select = TRUE, select.column.name = "ids",  select.val = 3:6, unique = TRUE)
file.remove (database)

}
\author{
Elena N. Filatova
}
