% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subDist2Mat.R
\name{subDist2Mat}
\alias{subDist2Mat}
\title{Dist2Mat subsetting}
\usage{
subDist2Mat(dist, idx1, idx2)
}
\arguments{
\item{dist}{A "dist" object, which can be computed via the stats::dist function, representing the full pairwise distance matrix between observations.}

\item{idx1}{An integer vector, specifying the row indices of the subsetted matrix.}

\item{idx2}{An integer vector, specifying the column indices of the subsetted matrix.}
}
\value{
A numeric matrix storing pairwise distances between observations column-indexed by \code{idx1} and row-indexed by \code{idx2}.
}
\description{
Efficiently extracts a 2d submatrix of pairwise distances from a "dist" object.
}
\details{
This function efficiently subsets a "dist" object by row and column indices, returning the corresponding rectangular section as a numeric matrix.
It avoids explicit conversion from the "dist" object to a dense "matrix", improving memory efficiency and computational speed, especially with large datasets.
}
\examples{

library("microbenchmark")
x = matrix(rnorm(200), nrow = 50)
dx = dist(x)
#Randomly subsetting a 10x10 matrix
idx1 = sample(1:50, 10)
idx2 = sample(1:50, 10)
microbenchmark(base::as.matrix(dx)[idx1,idx2],
               proxy::as.matrix(dx)[idx1,idx2],
               subDist2Mat(dx, idx1, idx2))
#Check if equal
v1 = as.vector(base::as.matrix(dx)[idx1,idx2])
v2 = as.vector(subDist2Mat(dx, idx1, idx2))
all.equal(v1, v2)

}
\author{
Minh Long Nguyen \email{edelweiss611428@gmail.com}
}
