% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/momentum_aggregate.R
\name{momentum_aggregate}
\alias{momentum_aggregate}
\title{Aggregate \code{momentum()} Data Frames Across Parameter Combinations}
\usage{
momentum_aggregate(df = NULL, f = mean, ...)
}
\arguments{
\item{df}{(required, data frame) Output of \code{\link[=momentum]{momentum()}}, \code{\link[=momentum_ls]{momentum_ls()}}, or \code{\link[=momentum_dtw]{momentum_dtw()}}. Default: NULL}

\item{f}{(optional, function) Function to summarize psi scores (for example, \code{mean}) when there are several combinations of parameters in \code{df}. Ignored when there is a single combination of arguments in the input. Default: \code{mean}}

\item{...}{(optional, arguments of \code{f}) Further arguments to pass to the function \code{f}.}
}
\value{
data frame
}
\description{
The function \code{\link[=momentum]{momentum()}} allows variable importance assessments based on several combinations of arguments at once. For example, when the argument \code{distance} is set to \code{c("euclidean", "manhattan")}, the output data frame will show two importance scores for each pair of compared time series and variable, one based on euclidean distances, and another based on manhattan distances.

This function computes importance stats across combinations of parameters.

If there are no different combinations of arguments in the input data frame, no aggregation happens, but all parameter columns are removed.
}
\examples{
#three time series
#climate and ndvi in Fagus sylvatica stands in Spain, Germany, and Sweden
tsl <- tsl_initialize(
  x = fagus_dynamics,
  name_column = "name",
  time_column = "time"
) |>
  tsl_transform(
    f = f_scale_global
  )

if(interactive()){
  tsl_plot(
    tsl = tsl,
    guide_columns = 3
    )
}

#momentum with multiple parameter combinations
#-------------------------------------
df <- momentum(
  tsl = tsl,
  distance = c("euclidean", "manhattan"),
  lock_step = TRUE
)

df[, c(
  "x",
  "y",
  "distance",
  "importance"
)]

#aggregation using means
df <- momentum_aggregate(
  df = df,
  f = mean
)

df
}
\seealso{
Other momentum_support: 
\code{\link{momentum_boxplot}()},
\code{\link{momentum_model_frame}()},
\code{\link{momentum_spatial}()},
\code{\link{momentum_stats}()},
\code{\link{momentum_to_wide}()}
}
\concept{momentum_support}
