% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsl_stats.R
\name{tsl_stats}
\alias{tsl_stats}
\title{Summary Statistics of Time Series Lists}
\usage{
tsl_stats(tsl = NULL, lags = 1L)
}
\arguments{
\item{tsl}{(required, list) Time series list. Default: NULL}

\item{lags}{(optional, integer) An integer specifying the number of autocorrelation lags to compute. If NULL, autocorrelation computation is disabled. Default: 1.}
}
\value{
data frame:
\itemize{
\item name: name of the zoo object.
\item rows: rows of the zoo object.
\item columns: columns of the zoo object.
\item time_units: time units of the zoo time series (see \code{\link[=zoo_time]{zoo_time()}}).
\item time_begin: beginning time of the time series.
\item time_end: end time of the time series.
\item time_length: total length of the time series, expressed in time units.
\item time_resolution: average distance between consecutive observations
\item variable: name of the variable, a column of the zoo object.
\item min: minimum value of the zoo column.
\item q1: first quartile (25th percentile).
\item median: 50th percentile.
\item q3: third quartile (75th percentile).
\item max: maximum value.
\item mean: average value.
\item sd: standard deviation.
\item range: range of the variable, computed as max - min.
\item iq_range: interquartile range of the variable, computed as q3 - q1.
\item skewness: asymmetry of the variable distribution.
\item kurtosis:"tailedness" of the variable distribution.
\item ac_lag_1, ac_lag_2, ...: autocorrelation values for the specified lags.
}
}
\description{
This function computes a variety of summary statistics for each time series and numeric column within a time series list. The statistics include common metrics  such as minimum, maximum, quartiles, mean, standard deviation, range, interquartile range, skewness, kurtosis, and autocorrelation for specified lags.

For irregular time series, autocorrelation computation is performed after regularizing the time series via interpolation with \code{\link[=zoo_resample]{zoo_resample()}}. This regularization does not affect the computation of all other stats.

This function supports a parallelization setup via \code{\link[future:plan]{future::plan()}}, and progress bars provided by the package \href{https://CRAN.R-project.org/package=progressr}{progressr}.
}
\examples{


#three time series
#climate and ndvi in Fagus sylvatica stands in Spain, Germany, and Sweden
tsl <- tsl_initialize(
  x = fagus_dynamics,
  name_column = "name",
  time_column = "time"
)


#stats computation
df <- tsl_stats(
  tsl = tsl,
  lags = 3
  )

df
}
\seealso{
Other tsl_processing: 
\code{\link{tsl_aggregate}()},
\code{\link{tsl_resample}()},
\code{\link{tsl_smooth}()},
\code{\link{tsl_transform}()}
}
\concept{tsl_processing}
