% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_check_args.R
\name{utils_check_args_momentum}
\alias{utils_check_args_momentum}
\title{Check Input Arguments of \code{momentum()}}
\usage{
utils_check_args_momentum(
  tsl = NULL,
  distance = NULL,
  diagonal = NULL,
  bandwidth = NULL,
  lock_step = NULL,
  robust = NULL
)
}
\arguments{
\item{tsl}{(required, time series list) list of zoo time series. Default: NULL}

\item{distance}{(optional, character vector) name or abbreviation of the distance method. Valid values are in the columns "names" and "abbreviation" of the dataset \link{distances}. Default: "euclidean".}

\item{diagonal}{(optional, logical vector). If TRUE, diagonals are included in the dynamic time warping computation. Default: TRUE}

\item{bandwidth}{(optional, numeric) Proportion of space at each side of the cost matrix diagonal (aka \emph{Sakoe-Chiba band}) defining a valid region for dynamic time warping, used to control the flexibility of the warping path. This method prevents degenerate alignments due to differences in magnitude between time series when the data is not properly scaled. If \code{1} (default), DTW is unconstrained. If \code{0}, DTW is fully constrained and the warping path follows the matrix diagonal. Recommended values may vary depending on the nature of the data. Ignored if \code{lock_step = TRUE}. Default: 1.}

\item{lock_step}{(optional, logical vector) If TRUE, time series captured at the same times are compared sample wise (with no dynamic time warping). Requires time series in argument \code{tsl} to be fully aligned, or it will return an error. Default: FALSE.}

\item{robust}{(required, logical). If TRUE (default), importance scores are computed using the least cost path of the complete time series as reference. Setting it to FALSE allows to replicate importance scores of the previous versions of this package. This option is irrelevant when \code{lock_step = TRUE}. Default: TRUE}
}
\value{
list
}
\description{
Check Input Arguments of \code{momentum()}
}
\seealso{
Other internal: 
\code{\link{utils_boxplot_common}()},
\code{\link{utils_check_args_distantia}()},
\code{\link{utils_check_args_matrix}()},
\code{\link{utils_check_args_path}()},
\code{\link{utils_check_args_tsl}()},
\code{\link{utils_check_args_zoo}()},
\code{\link{utils_check_distance_args}()},
\code{\link{utils_check_list_class}()},
\code{\link{utils_clean_names}()},
\code{\link{utils_digits}()},
\code{\link{utils_distantia_df_split}()},
\code{\link{utils_prepare_df}()},
\code{\link{utils_prepare_matrix}()},
\code{\link{utils_prepare_matrix_list}()},
\code{\link{utils_prepare_time}()},
\code{\link{utils_prepare_vector_list}()},
\code{\link{utils_prepare_zoo_list}()},
\code{\link{utils_tsl_pairs}()}
}
\concept{internal}
