% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_clean_names.R
\name{utils_clean_names}
\alias{utils_clean_names}
\title{Clean Character Vector of Names}
\usage{
utils_clean_names(
  x = NULL,
  lowercase = FALSE,
  separator = "_",
  capitalize_first = FALSE,
  capitalize_all = FALSE,
  length = NULL,
  suffix = NULL,
  prefix = NULL
)
}
\arguments{
\item{x}{(required, character vector) Names to be cleaned. Default: NULL}

\item{lowercase}{(optional, logical) If TRUE, all names are coerced to lowercase. Default: FALSE}

\item{separator}{(optional, character string) Separator when replacing spaces and dots and appending \code{suffix} and \code{prefix} to the main word. Default: "_".}

\item{capitalize_first}{(optional, logical) Indicates whether to capitalize the first letter of each name Default: FALSE.}

\item{capitalize_all}{(optional, logical) Indicates whether to capitalize all letters of each name Default: FALSE.}

\item{length}{(optional, integer) Minimum length of abbreviated names. Names are abbreviated via \code{\link[=abbreviate]{abbreviate()}}. Default: NULL.}

\item{suffix}{(optional, character string) String to append to the cleaned names. Default: NULL.}

\item{prefix}{(optional, character string)  String to prepend to the cleaned names. Default: NULL.}
}
\value{
character vector
}
\description{
Clean and format character vectors for use as column names or variable names.
}
\details{
The cleanup operations are applied in the following order:
\itemize{
\item Remove leading and trailing whitespaces.
\item Generates syntactically valid names with \code{\link[base:make.names]{base::make.names()}}.
\item Replaces dots and spaces with the \code{separator}.
\item Coerces names to lowercase.
\item If argument \code{length} is provided, \code{\link[base:abbreviate]{base::abbreviate()}} is used to abbreviate the new column names.
\item If \code{suffix} is provided, it is added at the end of the column name using the separator.
\item If \code{prefix} is provided, it is added at the beginning of the column name using the separator.
\item If \code{capitalize_first = TRUE}, the first letter is capitalized.
\item If \code{capitalize_all = TRUE}, all letters are capitalized.
}
}
\examples{
x <- c(
  "GerMany",
  "spain",
  "SWEDEN"
)

#abbreviate names
#---------------------------
#abbreviate to 4 characters
utils_clean_names(
  x = x,
  capitalize_all = TRUE,
  length = 4
)

#suffix and prefix
#---------------------------
utils_clean_names(
  x = x,
  capitalize_first = TRUE,
  separator = "_",
  prefix = "my_prefix",
  suffix = "my_suffix"
)
}
\seealso{
Other internal: 
\code{\link{utils_boxplot_common}()},
\code{\link{utils_check_args_distantia}()},
\code{\link{utils_check_args_matrix}()},
\code{\link{utils_check_args_momentum}()},
\code{\link{utils_check_args_path}()},
\code{\link{utils_check_args_tsl}()},
\code{\link{utils_check_args_zoo}()},
\code{\link{utils_check_distance_args}()},
\code{\link{utils_check_list_class}()},
\code{\link{utils_digits}()},
\code{\link{utils_distantia_df_split}()},
\code{\link{utils_prepare_df}()},
\code{\link{utils_prepare_matrix}()},
\code{\link{utils_prepare_matrix_list}()},
\code{\link{utils_prepare_time}()},
\code{\link{utils_prepare_vector_list}()},
\code{\link{utils_prepare_zoo_list}()},
\code{\link{utils_tsl_pairs}()}
}
\concept{internal}
