% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{covid_prevalence}
\alias{covid_prevalence}
\title{Time Series of Covid Prevalence in California Counties}
\format{
data frame with 3 columns and 51048 rows
}
\usage{
data(covid_prevalence)
}
\description{
Dataset with Covid19 maximum weekly prevalence in California counties between 2020 and 2024, from healthdata.gov.
}
\details{
County polygons and additional data for this dataset are in \link{covid_counties}.

The full dataset at daily resolution can be downloaded from \url{https://github.com/BlasBenito/distantia/blob/main/data_full/covid_prevalence.rda} (use the "Download raw file" button).
}
\examples{
#to time series list
tsl <- tsl_initialize(
  x = covid_prevalence,
  name_column = "name",
  time_column = "time"
)

#time series plot
if(interactive()){

 #subset to avoid margin errors
 tsl_plot(
  tsl = tsl_subset(
    tsl = tsl,
    names = 1:4
    ),
  guide = FALSE
  )

}
}
\seealso{
Other example_data: 
\code{\link{albatross}},
\code{\link{cities_coordinates}},
\code{\link{cities_temperature}},
\code{\link{covid_counties}},
\code{\link{eemian_coordinates}},
\code{\link{eemian_pollen}},
\code{\link{fagus_coordinates}},
\code{\link{fagus_dynamics}},
\code{\link{honeycomb_climate}},
\code{\link{honeycomb_polygons}}
}
\concept{example_data}
\keyword{datasets}
