library(distfreereg)
set.seed(20240227)
n <- 1e2
func <- function(x, theta) theta[1] + theta[2]*x[1] + theta[3]*x[2]
Sig <- rWishart(1, df = n, Sigma = diag(n))[,,1]
theta <- c(2,5,1)
X <- matrix(rexp(2*n, rate = 1), ncol = 2)
Y <- distfreereg:::f2ftheta(f = func, X)(theta) +
  as.vector(distfreereg:::rmvnorm(n = n, reps = 1, mean = rep(0,n), SqrtSigma = distfreereg:::matsqrt(Sig)))

dfr_1 <- distfreereg(Y = Y, X = X, test_mean = func, covariance = list(Sigma = Sig), theta_init = c(1,1,1), verbose = FALSE)
dfr_2 <- distfreereg(Y = Y, X = X, test_mean = func, covariance = list(Sigma = Sig), theta_init = c(1,1,1), verbose = FALSE,
                     control = list(optimization_fun = nlm,
                                    fun_to_optimize_arg = "f",
                                    theta_init_arg = "p",
                                    theta_hat_name = "estimate"))
dfr_1
dfr_2


tryCatch(distfreereg(Y = Y, X = X, test_mean = func, covariance = list(Sigma = Sig), theta_init = c(1,1,1), verbose = FALSE,
            control = list(optimization_fun = nlm,
                           fun_to_optimize_arg = "f",
                           theta_hat_name = "estimate")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func, covariance = list(Sigma = Sig), theta_init = c(1,1,1), verbose = FALSE,
            control = list(optimization_fun = nlm,
                           fun_to_optimize_arg = "f",
                           theta_init_arg = "p")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func, covariance = list(Sigma = Sig), theta_init = c(1,1,1), verbose = FALSE,
            control = list(optimization_fun = nlm,
                           fun_to_optimize_arg = "f",
                           theta_hat_name = "estimate")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func, covariance = list(Sigma = Sig), theta_init = c(1,1,1), verbose = FALSE,
            control = list(optimization_fun = nlm,
                           theta_hat_name = "estimate",
                           theta_init_arg = "p")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func, covariance = list(Sigma = Sig), theta_init = c(1,1,1), verbose = FALSE,
            control = list(optimization_fun = "nlm",
                           fun_to_optimize_arg = "f",
                           theta_hat_name = "estimate",
                           theta_init_arg = "p")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func, covariance = list(Sigma = Sig), theta_init = c(1,1,1), verbose = FALSE,
            control = list(optimization_fun = nlm,
                           fun_to_optimize_arg = c("f", "g"),
                           theta_hat_name = "estimate",
                           theta_init_arg = "p")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func, covariance = list(Sigma = Sig), theta_init = c(1,1,1), verbose = FALSE,
            control = list(optimization_fun = nlm,
                           fun_to_optimize_arg = "f",
                           theta_hat_name = c("estimate", "b"),
                           theta_init_arg = "p")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func, covariance = list(Sigma = Sig), theta_init = c(1,1,1), verbose = FALSE,
            control = list(optimization_fun = nlm,
                           fun_to_optimize_arg = "f",
                           theta_hat_name = "estimate",
                           theta_init_arg = c("p", "q"))),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func, covariance = list(Sigma = Sig), theta_init = c(1,1,1), verbose = FALSE,
            control = list(optimization_fun = nlm,
                           fun_to_optimize_arg = "func",
                           theta_hat_name = "estimate",
                           theta_init_arg = "p")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func, covariance = list(Sigma = Sig), theta_init = c(1,1,1), verbose = FALSE,
            control = list(optimization_fun = nlm,
                           fun_to_optimize_arg = "f",
                           theta_hat_name = "est",
                           theta_init_arg = "p")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func, covariance = list(Sigma = Sig), theta_init = c(1,1,1), verbose = FALSE,
            control = list(optimization_fun = nlm,
                           fun_to_optimize_arg = "f",
                           theta_hat_name = "estimate",
                           theta_init_arg = "pq")),
         error = function(e) warning(e))

tryCatch(distfreereg(Y = Y, X = X, test_mean = func, covariance = list(Sigma = Sig), theta_init = c(1,1,1), verbose = FALSE,
            control = list(fun_to_optimize_arg = "func",
                           theta_hat_name = "estimate",
                           theta_init_arg = "p")),
         error = function(e) warning(e))

