% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqplot.R
\name{qqplot}
\alias{qqplot}
\title{Quantile-Quantile Plots for distr6 Objects}
\usage{
qqplot(x, y, npoints = 3000, idline = TRUE, plot = TRUE, ...)
}
\arguments{
\item{x}{\code{distr6} object or numeric vector.}

\item{y}{\code{distr6} object or numeric vector.}

\item{npoints}{number of evaluation points.}

\item{idline}{logical; if TRUE (default), the line \eqn{y = x} is plotted}

\item{plot}{logical; if TRUE (default), figures are displayed in the plot window; otherwise a \code{data.table} of points and calculated values is returned.}

\item{...}{graphical parameters.}
}
\description{
Quantile-quantile plots are used to compare a "theoretical" or empirical distribution
to a reference distribution. They can also compare the quantiles of two reference distributions.
}
\details{
If \code{x} or \code{y} are given as numeric vectors then they are first passed to the \code{\link{Empirical}} distribution.
The \code{Empirical} distribution is a discrete distribution so quantiles are equivalent to the the Type 1 method
in \code{\link[stats]{quantile}}.
}
\examples{
qqplot(Normal$new(mean = 15, sd = sqrt(30)), ChiSquared$new(df = 15))
qqplot(rt(200, df = 5), rt(300, df = 5), main = "QQ-Plot", xlab = "t-200",
       ylab = "t-300")
qqplot(Normal$new(mean = 2), rnorm(100, mean = 3))

}
\seealso{
\code{\link{plot.Distribution}} for plotting a \code{distr6} object.
}
\author{
Chijing Zeng
}
