% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distribution.R
\name{liesInSupport}
\alias{liesInSupport}
\title{Test if Data Lies in Distribution Support}
\usage{
liesInSupport(object, x, all = TRUE, bound = FALSE)
}
\arguments{
\item{object}{Distribution.}

\item{x}{vector of numerics to test.}

\item{all}{logical, see details.}

\item{bound}{logical, if FALSE (default) uses dmin/dmax otherwise inf/sup.}
}
\value{
Either a vector of logicals if \code{all} is FALSE otherwise returns TRUE if every element
lies in the distribution support or FALSE otherwise.
}
\description{
Tests if the given data lies in the support of the Distribution, either tests if all
data lies in the support or any of it.
}
\details{
If \code{all} is TRUE (default) returns TRUE only if every element in \code{x}
lies in the support. If \code{all} is FALSE then returns a vector of logicals for each corresponding element
in the vector \code{x}.
}
\section{R6 Usage}{
 $liesInSupport(x, all = TRUE, bound = FALSE)
}

\seealso{
\code{\link{liesInType}}
}
