% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logistic.R
\name{pdf.Logistic}
\alias{pdf.Logistic}
\alias{log_pdf.Logistic}
\title{Evaluate the probability mass function of a Logistic distribution}
\usage{
\method{pdf}{Logistic}(d, x, ...)

\method{log_pdf}{Logistic}(d, x, ...)
}
\arguments{
\item{d}{A \code{Logistic} object created by a call to \code{\link[=Logistic]{Logistic()}}.}

\item{x}{A vector of elements whose probabilities you would like to
determine given the distribution \code{d}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of probabilities, one for each element of \code{x}.
}
\description{
Please see the documentation of \code{\link[=Logistic]{Logistic()}} for some properties
of the Logistic distribution, as well as extensive examples
showing to how calculate p-values and confidence intervals.
}
\examples{

set.seed(27)

X <- Logistic(2, 4)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other Logistic distribution: 
\code{\link{cdf.Logistic}()},
\code{\link{quantile.Logistic}()},
\code{\link{random.Logistic}()}
}
\concept{Logistic distribution}
