% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_cdf}
\alias{plot_cdf}
\title{Plot the CDF of a distribution}
\usage{
plot_cdf(d, limits = NULL, p = 0.001, plot_theme = NULL)
}
\arguments{
\item{d}{A \code{distribution} object}

\item{limits}{either \code{NULL} (default) or a vector of length 2 that specifies the range of the x-axis}

\item{p}{If \code{limits} is \code{NULL}, the range of the x-axis will be the support of \code{d} if this is a bounded
interval, or \code{quantile(d, p)} and \code{quantile(d, 1 - p)} if lower and/or upper limits of the support is
\code{-Inf}/\code{Inf}.  Defaults to 0.001.}

\item{plot_theme}{specify theme of resulting plot using \code{ggplot2}. Default is \code{theme_minimal}}
}
\description{
A function to easily plot the CDF of a distribution using \code{ggplot2}. Requires \code{ggplot2} to be loaded.
}
\examples{

N1 <- Normal()
plot_cdf(N1)

N2 <- Normal(0, c(1, 2))
plot_cdf(N2)

B1 <- Binomial(10, 0.2)
plot_cdf(B1)

B2 <- Binomial(10, c(0.2, 0.5))
plot_cdf(B2)
}
