% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZTNegativeBinomial.R
\name{ZTNegativeBinomial}
\alias{ZTNegativeBinomial}
\title{Create a zero-truncated negative binomial distribution}
\usage{
ZTNegativeBinomial(mu, theta)
}
\arguments{
\item{mu}{Location parameter of the negative binomial component of the distribution.
Can be any positive number.}

\item{theta}{Overdispersion parameter of the negative binomial component of the distribution.
Can be any positive number.}
}
\value{
A \code{ZTNegativeBinomial} object.
}
\description{
Zero-truncated negative binomial distributions are frequently used to model counts
where zero observations cannot occur or have been excluded.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail.

In the following, let \eqn{X} be a zero-truncated negative binomial random variable with parameter
\code{mu} = \eqn{\mu}.

\strong{Support}: \eqn{\{1, 2, 3, ...\}}{{1, 2, 3, ...}}

\strong{Mean}:
\deqn{
    \mu \cdot \frac{1}{1 - F(0; \mu, \theta)}
  }{
    \mu \cdot 1/(1 - F(0; \mu, \theta))
  }

where \eqn{F(k; \mu, \theta)} is the c.d.f. of the \code{\link{NegativeBinomial}} distribution.

\strong{Variance}: \eqn{m \cdot (\mu + 1 - m)}, where \eqn{m} is the mean above.

\strong{Probability mass function (p.m.f.)}:

\deqn{
    P(X = k) = \frac{f(k; \mu, \theta)}{1 - F(0; \mu, \theta)}
  }{
    P(X = k) = f(k; \mu, \theta)/(1 - F(0; \mu, \theta))
  }

where \eqn{f(k; \mu, \theta)} is the p.m.f. of the \code{\link{NegativeBinomial}}
distribution.

\strong{Cumulative distribution function (c.d.f.)}:

\deqn{
    P(X = k) = \frac{F(k; \mu, \theta)}{1 - F(0; \mu, \theta)}
  }{
    P(X = k) = F(k; \mu, \theta)/(1 - F(0; \mu, \theta))
  }

\strong{Moment generating function (m.g.f.)}:

Omitted for now.
}
\examples{
## set up a zero-truncated negative binomial distribution
X <- ZTNegativeBinomial(mu = 2.5, theta = 1)
X

## standard functions
pdf(X, 0:8)
cdf(X, 0:8)
quantile(X, seq(0, 1, by = 0.25))

## cdf() and quantile() are inverses for each other
quantile(X, cdf(X, 3))

## density visualization
plot(0:8, pdf(X, 0:8), type = "h", lwd = 2)

## corresponding sample with histogram of empirical frequencies
set.seed(0)
x <- random(X, 500)
hist(x, breaks = -1:max(x) + 0.5)
}
\seealso{
Other discrete distributions: 
\code{\link{Bernoulli}()},
\code{\link{Binomial}()},
\code{\link{Categorical}()},
\code{\link{Geometric}()},
\code{\link{HurdleNegativeBinomial}()},
\code{\link{HurdlePoisson}()},
\code{\link{HyperGeometric}()},
\code{\link{Multinomial}()},
\code{\link{NegativeBinomial}()},
\code{\link{Poisson}()},
\code{\link{PoissonBinomial}()},
\code{\link{ZINegativeBinomial}()},
\code{\link{ZIPoisson}()},
\code{\link{ZTPoisson}()}
}
\concept{discrete distributions}
