% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{plot.transform}
\alias{plot.transform}
\title{Visualize Information for an "transform" Object}
\usage{
\method{plot}{transform}(x, ...)
}
\arguments{
\item{x}{an object of class "transform", usually, a result of a call to transform().}

\item{...}{arguments to be passed to methods, such as graphical parameters (see par).}
}
\description{
Visualize two kinds of plot by attribute of `transform` class.
The Transformation of a numerical variable is a density plot.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Standardization ------------------------------
advertising_minmax <- transform(carseats$Advertising, method = "minmax")
advertising_minmax
summary(advertising_minmax)
plot(advertising_minmax)

# Resolving Skewness  --------------------------
advertising_log <- transform(carseats$Advertising, method = "log")
advertising_log
summary(advertising_log)
plot(advertising_log)
}
\seealso{
\code{\link{transform}}, \code{\link{summary.transform}}.
}
