% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{plot.optimal_bins}
\alias{plot.optimal_bins}
\title{Visualize Distribution for an "optimal_bins" Object}
\usage{
\method{plot}{optimal_bins}(x, type = c("dist", "goodrate", "badrate", "WoE"), sub = "", ...)
}
\arguments{
\item{x}{an object of class "optimal_bins", usually,
a result of a call to binning_by().}

\item{type}{options for visualization. Distribution ("dist"), Good Rate ("goodrate"),
Bad Rate ("badrate"), and Weight of Evidence ("WoE").}

\item{sub}{subtitle for the chart (optional).}

\item{...}{arguments to be passed to methods, such as graphical parameters (see par).
only applies to the first graph that is implemented with the boxplot() function.}
}
\description{
It generates plots for distribution, bad rate, and weight of evidence after
running smbinning and saving its output.

See vignette("transformation") for an introduction to these concepts.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# optimal binning
bin <- binning_by(carseats, "US", "Advertising")
bin

# summary optimal_bins class
summary(bin)

# information value
attr(bin, "iv")

# information value table
attr(bin, "ivtable")

# visualize optimal_bins class
plot(bin, sub = "bins of Advertising variable")
}
\seealso{
\code{\link{binning_by}}, \code{\link{plot.bins}}, \code{\link{smbinning.plot}}.
}
