% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate.R
\name{univar_category}
\alias{univar_category}
\alias{univar_category.data.frame}
\title{Statistic of univariate categorical variables}
\usage{
univar_category(.data, ...)

\method{univar_category}{data.frame}(.data, ...)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.}
}
\value{
An object of the class as individual variables based list.
The information to examine the relationship between categorical variables is as follows each components.

\itemize{
\item variable : factor. The level of the variable. 'variable' is the name of the variable.
\item n : integer. frequency by variable.
\item rate : double. relative frequency.
}
}
\description{
The univar_category() calculates statistic of categorical variables that is frequency table
}
\details{
univar_category() calculates the frequency table of categorical variables. 
If a specific variable name is not specified, frequency tables for all categorical variables included in the data are calculated.
The univar_category class returned by univar_category() is useful because it can draw chisqure tests and bar plots as well as frequency tables of individual variables.
and return univar_category class that based list object.
}
\section{Attributes of return object}{

Attributes of compare_category class is as follows.
\itemize{
\item variables : character. List of variables selected for calculate frequency.
}
}

\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

library(dplyr)
library(stringr)

# Calculates the all categorical variables
all_var <- univar_category(carseats)

# Print univar_category class object
all_var

# Calculates the only Urban variable
all_var \%>\% 
  "["(str_detect(names(all_var), "Urban"))
  
urban <- univar_category(carseats, Urban)
  
# Print univar_category class object
urban

# Filtering the case of Urban included NA 
urban \%>\%
  "[["(1) \%>\% 
  filter(!is.na(Urban))
  
# Summary the all case : Return a invisible copy of an object.
stat <- summary(all_var)

# Summary by returned object
stat

# plot all variables
# plot(all_var)

# plot urban
# plot(urban)

# plot all variables by prompt
# plot(all_var, prompt = TRUE)

}
\seealso{
\code{\link{summary.univar_category}}, \code{\link{print.univar_category}}, \code{\link{plot.univar_category}}.
}
