% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discribe.R
\name{describe}
\alias{describe}
\alias{describe.data.frame}
\alias{describe.grouped_df}
\title{Compute descriptive statistic}
\usage{
describe(.data, ...)

\method{describe}{data.frame}(.data, ..., statistics = NULL, quantiles = NULL)

\method{describe}{grouped_df}(.data, ..., statistics = NULL, quantiles = NULL)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}} or a \code{\link{grouped_df}}.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, describe() will automatically start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.

See vignette("EDA") for an introduction to these concepts.}

\item{statistics}{character. the name of the descriptive statistic to calculate. The defaults is c("mean", "sd", "se_mean", "IQR", "skewness", "kurtosis", "quantiles")}

\item{quantiles}{numeric. list of quantiles to calculate. The values of elements must be between 0 and 1. and to calculate quantiles, you must include "quantiles" in the statistics argument value. The default is c(0, .01, .05, 0.1, 0.2, 0.25, 0.3, 0.4, 0.5, 0.6, 0.7, 0.75, 0.8, 0.9, 0.95, 0.99, 1).}
}
\value{
An object of the same class as .data.
}
\description{
The describe() compute descriptive statistic of numeric
variable for exploratory data analysis.
}
\details{
This function is useful when used with the \code{\link{group_by}} function
of the dplyr package.
If you want to calculate the statistic by level of the categorical data
you are interested in, rather than the whole statistic, you can use
grouped_df as the group_by() function.
}
\section{Descriptive statistic information}{

The information derived from the numerical data describe is as follows.

\itemize{
\item n : number of observations excluding missing values
\item na : number of missing values
\item mean : arithmetic average
\item sd : standard deviation
\item se_mean : standard error mean. sd/sqrt(n)
\item IQR : interquartile range (Q3-Q1)
\item skewness : skewness
\item kurtosis : kurtosis
\item p25 : Q1. 25\% percentile
\item p50 : median. 50\% percentile
\item p75 : Q3. 75\% percentile
\item p01, p05, p10, p20, p30 : 1\%, 5\%, 20\%, 30\% percentiles
\item p40, p60, p70, p80 : 40\%, 60\%, 70\%, 80\% percentiles
\item p90, p95, p99, p100 : 90\%, 95\%, 99\%, 100\% percentiles

}
}

\examples{
\donttest{
# Generate data for the example
heartfailure2 <- heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 20), "sodium"] <- NA
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "smoking"] <- NA

# Describe descriptive statistics of numerical variables
describe(heartfailure2)

# Select the variable to describe
describe(heartfailure2, sodium, platelets, statistics = c("mean", "sd", "quantiles"))
describe(heartfailure2, -sodium, -platelets)
describe(heartfailure2, 5, statistics = c("mean", "sd", "quantiles"), quantiles = c(0.01, 0.1))

# Using dplyr::grouped_dt
library(dplyr)

gdata <- group_by(heartfailure2, hblood_pressure, death_event)
describe(gdata, "creatinine")

# Using pipes ---------------------------------
# Positive values select variables
heartfailure2 \%>\%
  describe(platelets, sodium, creatinine)

# Negative values to drop variables
heartfailure2 \%>\%
  describe(-platelets, -sodium, -creatinine)

# Using pipes & dplyr -------------------------
# Find the statistic of all numerical variables by 'hblood_pressure' and 'death_event',
# and extract only those with 'hblood_pressure' variable level is "Yes".
heartfailure2 \%>\%
 group_by(hblood_pressure, death_event) \%>\%
   describe() \%>\%
   filter(hblood_pressure == "Yes")

# extract only those with 'smoking' variable level is "Yes",
# and find 'creatinine' statistics by 'hblood_pressure' and 'death_event'
heartfailure2 \%>\%
  filter(smoking == "Yes") \%>\%
  group_by(hblood_pressure, death_event) \%>\%
  describe(creatinine)
}

}
\seealso{
\code{\link{describe.tbl_dbi}}, \code{\link{diagnose_numeric.data.frame}}.
}
