% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc-package.R
\docType{data}
\name{animals}
\alias{animals}
\title{List of binary dissimilarity matrices among 18 animals.}
\format{
{
  A \code{\link{dmbc_data}} object whose \code{diss} element is a list of 20
  binary dissimilarity matrices. Each matrix is defined as a \code{dist}
  object measuring whether each pair of the 18 animals has is placed in the
  same group (1) or not (0).

  The \code{dist} objects have rows and columns that are named as follows:
  \describe{
    \item{be}{bear}
    \item{cm}{camel}
    \item{ct}{cat}
    \item{cw}{cow}
    \item{dg}{dog}
    \item{el}{elephant}
    \item{gf}{giraffe}
    \item{fx}{fox}
    \item{hs}{horse}
    \item{li}{lion}
    \item{mk}{monkey}
    \item{ms}{mouse}
    \item{pg}{pig}
    \item{rb}{rabbit}
    \item{sh}{sheep}
    \item{sq}{squirrel}
    \item{tg}{tiger}
    \item{wf}{wolf}
  }
}
}
\usage{
data(animals)
}
\description{
To illustrate the MDS analysis of sorting data, Takane et al. (2009) refer
  to judgments on the similarity between \emph{n} = 18 animals expressed by
  \emph{S} = 20 subjects. Each subject was asked to divide the animals into
  as many groups as needed, based on their similarity. We converted these
  values to 0 or 1 depending on whether a pair of animals is placed or not
  in the same group by a subject.
}
\examples{
data(animals)
library(bayesplot)
cols <- color_scheme_set("teal")
plot(animals, colors = unlist(cols)[c(1, 6)], font = 1, cex.font = 0.75)
}
\references{
Takane, Y., Jung, S., Takane, Y. O. (2009). "Multidimensional Scaling". In
  Millsap, R. E., Maydeu-Olivares, A. (eds.), The SAGE Handbook of
  Quantitative Methods in Psychology, chapter 10, pp. 217–242,.
}
\keyword{datasets}
