% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc_prior.R
\name{dmbc_prior}
\alias{dmbc_prior}
\alias{prior_dmbc}
\alias{check_prior}
\alias{update_prior}
\title{Auxiliary Function for Setting DMBC Model Priors}
\usage{
dmbc_prior(
  eta = list(a = rep(1.5, .dmbcEnv$current_G), b = rep(0.5, .dmbcEnv$current_G)),
  sigma2 = list(a = 0.1, b = 0.1),
  lambda = rep(1, .dmbcEnv$current_G)
)

prior_dmbc(
  eta = list(a = rep(1.5, .dmbcEnv$current_G), b = rep(0.5, .dmbcEnv$current_G)),
  sigma2 = list(a = 0.1, b = 0.1),
  lambda = rep(1, .dmbcEnv$current_G)
)

check_prior(prior)

update_prior(prior, p, G)
}
\arguments{
\item{eta}{A named list containing the hyperparameters for the prior
distribution of the \eqn{\eta_1,\ldots,\eta_G} parameters. It should
contain two numeric vectors, namely \code{a} and \code{b}.}

\item{sigma2}{A named list containing the hyperparameters for the prior
distributions of the \eqn{\sigma^2_1,\ldots,\sigma^2_G} parameters. It
should contain two numeric scalars, namely \code{a} and \code{b}.}

\item{lambda}{A list containing the hyperparameters for the prior
distribution of the \eqn{\lambda_1,\ldots,\lambda_G} parameters. It should
contain a single numeric vector.}

\item{prior}{A named list of prior hyperparameters.}

\item{p}{A length-one numeric vector indicating the number of dimensions of the
latent space.}

\item{G}{A length-one numeric vector indicating the number of cluster to
partition the \emph{S} subjects.}
}
\value{
A list with the prior hyperparameters as components.
}
\description{
{
\code{dmbc_prior()} is an auxiliary function as user interface for
  \code{dmbc()} fitting. Typically only used when calling the \code{dmbc()}
  function. It is used to set prior hyperparameters.

\code{prior_dmbc()} is an alias for \code{dmbc_prior()}.

\code{check_prior()} is an auxiliary function that verifies the
  correctness of the prior hyperparameters provided before a DMBC is fitted
  with \code{\link{dmbc}()}.

\code{update_prior()} is an auxiliary function to modify a set of prior
  choices using a new value of \emph{p} and \emph{G}. It is intended for
  internal use mainly in the \code{\link{dmbc_ic}()} function.
}
}
\examples{
\dontrun{
data(simdiss, package = "dmbc")
# Shorter run than default.
sim.fit <- dmbc(simdiss,
  control = dmbc_control(burnin = 1000, nsim = 2000, thin = 1, verbose = TRUE),
  prior = dmbc_prior(sigma2 = list(a = 1, b = 4)))
}

}
\seealso{
\code{\link{dmbc}()}
}
\author{
Sergio Venturini \email{sergio.venturini@unito.it}
}
\keyword{based}
\keyword{clustering}
\keyword{model}
