% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmutate.R
\docType{methods}
\name{mutate_random}
\alias{mutate_random}
\alias{mutate_random,data.frame,character-method}
\alias{mutate_random,data.frame,covobj-method}
\alias{mutate_random,data.frame,covset-method}
\alias{mutate_random,data.frame,formula-method}
\alias{mutate_random,data.frame,list-method}
\title{Add random variates to a data frame.}
\usage{
mutate_random(data, input, ...)

\S4method{mutate_random}{data.frame,formula}(data, input, ...)

\S4method{mutate_random}{data.frame,character}(data, input,
  envir = parent.frame(), ...)

\S4method{mutate_random}{data.frame,list}(data, input, ...)

\S4method{mutate_random}{data.frame,covset}(data, input, ...)

\S4method{mutate_random}{data.frame,covobj}(data, input,
  envir = parent.frame(), ...)
}
\arguments{
\item{data}{the data.frame to mutate}

\item{input}{an unquoted R formula; see details}

\item{...}{additional inputs}

\item{envir}{environment for object lookup}
}
\description{
Add random variates to a data frame.
}
\examples{

data <- data.frame(ID=1:10, GROUP = sample(c(1,2,3),10,replace=TRUE))

mutate_random(data, AGE[40,90] ~ rnorm(55,50))
mutate_random(data, RE ~ rbeta(1,1) | GROUP)

e <- list(lower=40,upper=140,mu=100,sd=100)

egfr <- covset(EGFR[lower,upper] ~ rnorm(mu,sd))

mutate_random(data,egfr,envir=e)

}

