% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{rename_genes}
\alias{rename_genes}
\title{Rename genes in the differential network analysis}
\usage{
rename_genes(x, gene_mat = NULL, to = NULL, species = NULL, ...)
}
\arguments{
\item{x}{A 'dnapath_list' or 'dnapath' object from \code{\link{dnapath}},
a pathway list, or a vector of gene names.}

\item{gene_mat}{(Optional) A matrix of key value pairs. The first column should contain
current gene names, and the second column the new names. Any genes that are
not in this matrix will retain their current names. This can be any
user-defined mapping, or the mapping obtained using
\code{\link{entrez_to_symbol}} or \code{\link{symbol_to_entrez}}.}

\item{to}{(Optional) Setting \code{to = "symbol"} will rename entrezgene IDs to
gene symbols; this will automatically call the \code{entrez_to_symbol()} function
to obtain the mapping for \code{gene_mat}. The \code{species} arugment must also be
specified when \code{to} is used.}

\item{species}{(Optional) Must be specified when setting \code{to = "symbol"}. This
argument is passed into \code{\link{entrez_to_symbol}}.}

\item{...}{Additional arugments are passed into \code{\link{entrez_to_symbol}}
in the case that \code{to} and \code{species} are specified. This may be useful to
specify the \code{dir_save} argument to save the mapping obtained from
biomaRt for offline use.}
}
\value{
Returns \code{x} with all gene names updated according to \code{gene_mat}.
}
\description{
Rename genes in the differential network analysis
}
\note{
Internet connection is required to connect to use
\code{\link{entrez_to_symbol}} or \code{\link{symbol_to_entrez}}.
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   groups = meso$groups, n_perm = 10)
summary(results[[1]])  # Summary of pathway 1; note that it uses entrezgene IDs.

\donttest{
# Rename the entrezgene IDs into gene symbols.
results_sym <- rename_genes(results, to = "symbol", species = "human")
summary(results_sym[[1]]) # Now the summary uses gene symbols.
}
}
\seealso{
\code{\link{entrez_to_symbol}}, \code{\link{symbol_to_entrez}}
}
