% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summarize_pathways}
\alias{summarize_pathways}
\title{Summarize the differential connectivity of pathways.}
\usage{
summarize_pathways(x, alpha = 1, alpha_gene = 0.1, monotonized = FALSE)
}
\arguments{
\item{x}{A 'dnapath_list' object from \code{\link{dnapath}}.}

\item{alpha}{Threshold for p-values of pathway DC scores.
Defaults to 1, which leads to results for all pathways being shown.}

\item{alpha_gene}{Threshold for p-values of gene DC scores. Used to determine
the number of genes that are differentially connected within each pathway.
Defaults to 0.1 or the minimum possible threshold for the number
of permutations performed, whichever is greater.}

\item{monotonized}{If TRUE, monotonized p-values are used.}
}
\value{
A tibble summarizing the differential connectivity of genes in
the pathway.
}
\description{
Summarize the differential connectivity of pathways.
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   group_labels = meso$groups, n_perm = 10)
summarize_pathways(results)
}
\seealso{
\code{\link{summarize_genes}}, \code{\link{summarize_edges}}
}
