% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/visNetAnimate.r
\name{visNetAnimate}
\alias{visNetAnimate}
\title{Function to animate the same graph but with multiple graph node colorings according to input data matrix}
\usage{
visNetAnimate(g, data, filename = "visNetAnimate", filetype = c("pdf",
"mp4", "gif"), num.frame = ncol(data), sec_per_frame = 1,
height.device = 7, margin = rep(0.1, 4), border.color = "#EEEEEE",
colormap = c("bwr", "jet", "gbr", "wyr", "br", "yr", "rainbow", "wb"),
ncolors = 40, zlim = NULL, colorbar = T, colorbar.fraction = 0.25,
glayout = layout.fruchterman.reingold, glayout.dynamics = F,
mtext.side = 3, mtext.adj = 0, mtext.cex = 1, mtext.font = 2,
mtext.col = "black", ...)
}
\arguments{
\item{g}{an object of class "igraph" or "graphNEL"}

\item{data}{an input data matrix used to color-code vertices/nodes. One
column corresponds to one graph node coloring. The input matrix must
have row names, and these names should include all node names of input
graph, i.e. V(g)$name, since there is a mapping operation. After
mapping, the length of the patern vector should be the same as the
number of nodes of input graph. The way of how to color-code is to map
values in the pattern onto the whole colormap (see the next arguments:
colormap, ncolors, zlim and colorbar)}

\item{filename}{the without-extension part of the name of the output
file. By default, it is 'visNetAnimate'}

\item{filetype}{the type of the output file, i.e. the extension of the
output file name. It can be one of either 'pdf' for the pdf file, 'mp4'
for the mp4 video file, 'gif' for the gif file}

\item{num.frame}{a numeric value specifying the number of
frames/images. By default, it sets to the number of columns in the
input data matrix}

\item{sec_per_frame}{a numeric value specifying how long (seconds) it
takes to stream a frame/image. This argument only works when producing
mp4 video or gif file.}

\item{height.device}{a numeric value specifying the height (or width)
of device/frame/image.}

\item{margin}{margins as units of length 4 or 1}

\item{border.color}{the border color of each figure}

\item{colormap}{short name for the colormap. It can be one of "jet"
(jet colormap), "bwr" (blue-white-red colormap), "gbr" (green-black-red
colormap), "wyr" (white-yellow-red colormap), "br" (black-red
colormap), "yr" (yellow-red colormap), "wb" (white-black colormap), and
"rainbow" (rainbow colormap, that is,
red-yellow-green-cyan-blue-magenta). Alternatively, any
hyphen-separated HTML color names, e.g. "blue-black-yellow",
"royalblue-white-sandybrown", "darkgreen-white-darkviolet". A list of
standard color names can be found in
\url{http://html-color-codes.info/color-names}}

\item{ncolors}{the number of colors specified over the colormap}

\item{zlim}{the minimum and maximum z/patttern values for which colors
should be plotted, defaulting to the range of the finite values of z.
Each of the given colors will be used to color an equispaced interval
of this range. The midpoints of the intervals cover the range, so that
values just outside the range will be plotted}

\item{colorbar}{logical to indicate whether to append a colorbar. If
pattern is null, it always sets to false}

\item{colorbar.fraction}{the relative fraction of colorbar block
against the figure block}

\item{glayout}{either a function or a numeric matrix configuring how
the vertices will be placed on the plot. If layout is a function, this
function will be called with the graph as the single parameter to
determine the actual coordinates. This function can be one of
"layout.auto", "layout.random", "layout.circle", "layout.sphere",
"layout.fruchterman.reingold", "layout.kamada.kawai", "layout.spring",
"layout.reingold.tilford", "layout.fruchterman.reingold.grid",
"layout.lgl", "layout.graphopt", "layout.svd" and "layout.norm". A full
explanation of these layouts can be found in
\url{http://igraph.org/r/doc/layout_nicely.html}}

\item{glayout.dynamics}{logical to indicate whether graph layout should
be dynamic. By default, it always sets to false. If YES, the
Fruchterman-Reingold layout algorithm
\url{http://igraph.org/r/doc/layout_with_fr.html} will be used to
stimulate the dynamic layout}

\item{mtext.side}{on which side of the mtext plot (1=bottom, 2=left,
3=top, 4=right)}

\item{mtext.adj}{the adjustment for mtext alignment (0 for left or
bottom alignment, 1 for right or top alignment)}

\item{mtext.cex}{the font size of mtext labels}

\item{mtext.font}{the font weight of mtext labels}

\item{mtext.col}{the color of mtext labels}

\item{...}{additional graphic parameters. See
\url{http://igraph.org/r/doc/plot.common.html} for the complete list.}
}
\value{
If specifying the output file name (see argument 'filename' above), the
output file is either 'filename.pdf' or 'filename.mp4' in the current
working directory. If no output file name specified, by default the
output file is either 'visNetAnimate.pdf' or 'visNetAnimate.mp4'
}
\description{
\code{visNetAnimate} is supposed to animate the same graph but with
multiple colorings according to input data matrix. The output can be a
pdf file containing a list of frames/images, a mp4 video file or a gif
file. To support video output file, the software 'ffmpeg' must be first
installed (also put its path into the system PATH variable; see Note).
To support gif output file, the software 'ImageMagick' must be first
installed (also put its path into the system PATH variable; see
\url{http://www.imagemagick.org/script/binary-releases.php}).
}
\note{
When producing mp4 video, this function requires the installation of
the software 'ffmpeg' at \url{https://www.ffmpeg.org}. Assuming you
have a ROOT (sudo) privilege, shell command lines for ffmpeg
installation in Terminal (for both Linux and Mac) are:
\cr
wget http://www.ffmpeg.org/releases/ffmpeg-2.7.1.tar.gz
\cr
tar xvfz ffmpeg-2.7.1.tar.gz
\cr
cd ffmpeg-2.7.1
\cr
./configure --disable-yasm
\cr
make
\cr
make install
\cr
ffmpeg -h
# Installation without Root privilege, please replace with:
./configure --disable-yasm --prefix=$HOME/ffmpeg-2.7.1
# Also add the system PATH variable to your ~/.bash_profile file
export PATH=$HOME/ffmpeg-2.7.1:$PATH
}
\examples{
\dontrun{
# 1) generate a random graph according to the ER model
g <- erdos.renyi.game(100, 1/100)

# 2) produce the induced subgraph only based on the nodes in query
subg <- dNetInduce(g, V(g), knn=0)

# 3) visualise the module with vertices being color-coded by scores
nnodes <- vcount(subg)
nsamples <- 10
data <- matrix(runif(nnodes*nsamples), nrow=nnodes, ncol=nsamples)
rownames(data) <- V(subg)$name
# output as a pdf file
visNetAnimate(g=subg, data=data, filetype="pdf")
# output as a mp4 file
visNetAnimate(g=subg, data=data, filetype="mp4")
# output as a mp4 file but with dynamic layout
visNetAnimate(g=subg, data=data, filetype="mp4", glayout.dynamics=TRUE)
}
}
\seealso{
\code{\link{visNetMul}}
}

