% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subSeq.R
\name{subSeq}
\alias{subSeq}
\title{Find sub-sequences of identical elements in a vector.}
\usage{
subSeq(x, item = NULL)
}
\arguments{
\item{x}{An atomic vector.}

\item{item}{Optionally a specific value to look for in 'x'.}
}
\value{
A dataframe.
}
\description{
Find sub-sequences of identical elements in a vector.
}
\examples{

x <- c(1, 1, 1, 0, 0, 1, 1, 1, 2, 2, 2, 1, 2, 2, 2, 3)
(ans <- subSeq(x))
ans$value
# Notice: Same results below
subSeq(x, item=1)
subSeq(x, item="1")

x <- as.character(c(1, 1, 1, 0, 0, 1, 1, 1, 2, 2, 2, 1, 2, 2, 2, 3))
(ans<-subSeq(x))
ans$value
# Notice: Same results below
subSeq(x, item="1")
subSeq(x, item=1)

}
\seealso{
\code{\link{rle}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
