% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.R
\name{is_continuous}
\alias{is_continuous}
\alias{is_quantity}
\alias{is_count}
\alias{is_money}
\alias{is_percentage}
\title{Check if x$data is a continuous variable}
\usage{
is_continuous(x, min_val = -Inf, max_val = Inf, max_na = 0.9,
  max_dec_places = Inf)

is_quantity(x, min_val = 0, max_val = Inf, max_na = 0.9,
  max_dec_places = Inf)

is_count(x, min_val = 0, max_val = Inf, max_na = 0.9,
  max_dec_places = 0)

is_money(x, min_val = 0, max_val = Inf, max_na = 0.9,
  max_dec_places = 2)

is_percentage(x, min_val = 0, max_val = 1, max_na = 0.9,
  max_dec_places = Inf)
}
\arguments{
\item{x}{List with data, result, and any errors already found}

\item{min_val}{Minimum value x$data can have}

\item{max_val}{Maximum value x$data can have}

\item{max_na}{Fraction of x$data that can be NA}

\item{max_dec_places}{Maximum number of decimal places in values of x$data}
}
\description{
Check if x$data is a continuous variable

Check if x$data is a quantity variable

Check if x$data is a count variable

Check if x$data is a money variable

Check if x$data is a percentage variable
}
