% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_parsing.R
\name{get_lines_between_tags}
\alias{get_lines_between_tags}
\title{get all lines between tagged lines}
\usage{
get_lines_between_tags(file_name, keep_tagged_lines = TRUE,
  begin_pattern = "ROXYGEN_START", end_pattern = "ROXYGEN_STOP",
  from_first_line = TRUE, to_last_line = TRUE)
}
\arguments{
\item{file_name}{The name of the R code file to be parsed.}

\item{keep_tagged_lines}{keep tagged lines output?}

\item{begin_pattern}{A pattern that marks the line beginning the roxygen
part.}

\item{end_pattern}{A pattern that marks the line ending the roxygen part.}

\item{from_first_line}{use first line as tagged line if first tag found
matches the end_pattern.}

\item{to_last_line}{use last line as tagged line if last tag found matches
the begin_pattern.}
}
\value{
a character vector of matching lines.
}
\description{
get all lines between tagged lines
}
\note{
If you know the file to contain valid roxygen code only, you do not
need to tag any lines if you keep from_first_line and to_last_line both TRUE:
in this case the whole file will be returned.
}
\author{
Andreas Dominik Cullmann, <adc-r@arcor.de>
}
