% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match-points.R
\name{match_points_to_verts}
\alias{match_points_to_verts}
\title{match_points_to_verts}
\usage{
match_points_to_verts(verts, xy, connected = FALSE)
}
\arguments{
\item{verts}{A \code{data.frame} of vertices obtained from
\code{dodgr_vertices(graph)}.}

\item{xy}{coordinates of points to be matched to the vertices, either as
matrix or \pkg{sf}-formatted \code{data.frame}.}

\item{connected}{Should points be matched to the same (largest) connected
component of graph? If \code{FALSE} and these points are to be used for a
\code{dodgr} routing routine (\link{dodgr_dists}, \link{dodgr_paths}, or
\link{dodgr_flows_aggregate}), then results may not be returned if points are
not part of the same connected component. On the other hand, forcing them to
be part of the same connected component may decrease the spatial accuracy of
matching.}
}
\value{
A vector index into verts
}
\description{
Alias for \link{match_pts_to_verts}
}
\examples{
net <- weight_streetnet (hampi, wt_profile = "foot")
verts <- dodgr_vertices (net)
# Then generate some random points to match to graph
npts <- 10
xy <- data.frame (
    x = min (verts$x) + runif (npts) * diff (range (verts$x)),
    y = min (verts$y) + runif (npts) * diff (range (verts$y))
)
pts <- match_pts_to_verts (verts, xy)
pts # an index into verts
pts <- verts$id [pts]
pts # names of those vertices
}
\seealso{
Other match: 
\code{\link{add_nodes_to_graph}()},
\code{\link{match_points_to_graph}()},
\code{\link{match_pts_to_graph}()},
\code{\link{match_pts_to_verts}()}
}
\concept{match}
