% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dominanceAnalysis.R
\name{plot.dominanceAnalysis}
\alias{plot.dominanceAnalysis}
\title{Plot for a \code{\link{dominanceAnalysis}} object}
\usage{
\method{plot}{dominanceAnalysis}(
  x,
  which.graph = c("general", "complete", "complete_no_facet", "conditional"),
  fit.function = NULL,
  ...
)
}
\arguments{
\item{x}{a \code{\link{dominanceAnalysis}} object}

\item{which.graph}{which graph to plot}

\item{fit.function}{name of the fit indices to retrieve. If NULL, first index will be used}

\item{...}{unused}
}
\value{
a ggplot object
}
\description{
Plot for a \code{\link{dominanceAnalysis}} object
}
\examples{
data(longley)
lm.1<-lm(Employed~.,longley)
da<-dominanceAnalysis(lm.1)
# By default, plot complete dominance of first fit function
plot(da)
# Parameter which.graph defines dominance to plot
plot(da,which.graph='conditional')
plot(da,which.graph='general')
}
