% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.wrda.R
\name{anova.wrda}
\alias{anova.wrda}
\title{Permutation Test for weighted redundancy analysis}
\usage{
\method{anova}{wrda}(object, ..., permutations = 999, by = c("omnibus", "axis"))
}
\arguments{
\item{object}{an object from \code{\link{dc_CA}}.}

\item{...}{unused.}

\item{permutations}{a list of control values for the permutations as
returned by the function \code{\link[permute]{how}}, or the number of 
permutations required (default 999), or a permutation matrix where each row
gives the permuted indices.}

\item{by}{character \code{"axis"} which sets the test statistic to the
first eigenvalue of the RDA model. Default: \code{NULL} which sets the test
statistic to the weighted variance fitted by the predictors
(=sum of all constrained eigenvalues). The default is quicker 
computationally as it avoids computation of an svd of permuted data sets.}
}
\value{
A list with two elements with names \code{table} and \code{eigenvalues}.
The \code{table} is as from \code{\link[vegan]{anova.cca}} and 
\code{eigenvalues} gives the wrda eigenvalues.
}
\description{
\code{anova.wrda} performs residual predictor permutation for weighted 
redundancy analysis (wRDA), which is robust against differences in the 
weights (ter Braak, 2022). The arguments of the function are similar to 
those of \code{\link[vegan]{anova.cca}}, but more restricted.
}
\details{
The algorithm is based on published R-code for residual predictor 
permutation in weighted redundancy analysis (ter Braak, 2022), but
using QR-decomposition instead of ad-hoc least-squares functions.
}
\examples{
data("dune_trait_env")

# rownames are carried forward in results
rownames(dune_trait_env$comm) <- dune_trait_env$comm$Sites
response <- dune_trait_env$comm[, -1]  # must delete "Sites"

w <- rep(1, 20) 
w[1:10] <- 8 
w[17:20] <- 0.5

object <- wrda(formula = ~ A1 + Moist + Mag + Use + Condition(Manure),
               response = response, 
               data = dune_trait_env$envir, 
               weights = w)
object # Proportions equal to those Canoco 5.15

mod_scores <- scores(object, display = "all")
scores(object, which_cor = c("A1", "X_lot"), display = "cor")
anova(object)
}
\references{
ter Braak, C.J.F. (2022) Predictor versus response permutation
for significance testing in weighted regression and redundancy analysis.
Journal of statistical computation and simulation, 92, 2041-2059.
\doi{10.1080/00949655.2021.2019256}
}
