% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/test_counts.R
\name{test_counts}
\alias{test_counts}
\title{Test counts}
\usage{
test_counts(input, model = "binomial", conf.level = 0.95)
}
\arguments{
\item{input}{adpcr or dpcr object with with "nm" type.}

\item{model}{may have one of following values: \code{binomial}, \code{poisson},
\code{prop}, \code{ratio}.}

\item{conf.level}{confidence level of the intervals and groups.}
}
\value{
an object of class \code{\linkS4class{count_test}}.
}
\description{
The test for comparing counts from two or more digital PCR experiments.
}
\details{
\code{test_counts} fits counts data from different
digital PCR experiments to Generalized Linear Model (using quasibinomial
or quasipoisson \code{\link[stats]{family}}). Comparisions between single experiments
utilize Tukey's contrast and multiple t-tests (as provided by function \code{\link{glht}}).
}
\note{
Mean number of template molecules per partitions and its confidence intervals are derived
from General Linear Models. Their values will vary depending on input.
}
\examples{
adpcr1 <- sim_adpcr(m = 10, n = 765, times = 1000, pos_sums = FALSE, n_panels = 3)
adpcr2 <- sim_adpcr(m = 60, n = 550, times = 1000, pos_sums = FALSE, n_panels = 3)
adpcr3 <- sim_adpcr(m = 10, n = 600, times = 1000, pos_sums = FALSE, n_panels = 3)

#compare experiments using binomial regression
two_groups_bin <- test_counts(bind_dpcr(adpcr1, adpcr2), model = "binomial")
summary(two_groups_bin)
plot(two_groups_bin)
#plot aggregated results
plot(two_groups_bin, aggregate = TRUE)
#get coefficients
coef(two_groups_bin)

#this time use Poisson regression
two_groups_pois <- test_counts(bind_dpcr(adpcr1, adpcr2), model = "poisson")
summary(two_groups_pois)
plot(two_groups_pois)

#see how test behaves when results aren't significantly different
one_group <- test_counts(bind_dpcr(adpcr1, adpcr3))
summary(one_group)
plot(one_group)
}
\author{
Michal Burdukiewicz, Stefan Roediger, Piotr Sobczyk.
}
\references{
Bretz F, Hothorn T, Westfall P, \emph{Multiple comparisons using R}.
Boca Raton, Florida, USA: Chapman & Hall/CRC Press (2010).
}
\seealso{
Functions used by \code{test_counts}:
\itemize{
\item \code{\link[stats]{glm}},
\item \code{\link[multcomp]{glht}},
\item \code{\link[multcomp]{cld}},
\item \code{\link[stats]{prop.test}},
\item \code{\link[rateratio.test]{rateratio.test}}
}

GUI presenting capabilities of the test: \code{\link{test_counts_gui}}.
}

