% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped-df.r
\name{group_cols}
\alias{group_cols}
\title{Select grouping variables}
\usage{
group_cols(vars = peek_vars())
}
\arguments{
\item{vars}{A character vector of variable names. When called
from inside selecting functions like \code{\link[dplyr:select]{dplyr::select()}} these are
automatically set to the names of the table.}
}
\description{
This selection helpers matches grouping variables. It can be used
in \code{\link[=select]{select()}} or \link[=scoped]{vars()} selections.
}
\examples{
gdf <- iris \%>\% group_by(Species)

# Select the grouping variables:
gdf \%>\% select(group_cols())

# Remove the grouping variables from mutate selections:
gdf \%>\% mutate_at(vars(-group_cols()), `/`, 100)
}
\seealso{
\code{\link[=groups]{groups()}} and \code{\link[=group_vars]{group_vars()}} for retrieving the grouping
variables outside selection contexts.
}
