% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SSFunctions.R
\docType{data}
\name{SSl5}
\alias{SSl5}
\title{Self-Starting Nls 5 parameters logistic regression model}
\format{A selfStart model}
\usage{
SSl5(x, Slope, lAsym, hAsym, xMid, Asymetry)
}
\arguments{
\item{x}{a numeric vector of values at which to evaluate the model}

\item{Slope}{is a numeric parameter representing the \code{-slope} of the
function at the inflection point}

\item{lAsym}{a numeric parameter representing the lower asymptote when
\code{x} trend to \code{-Inf}}

\item{hAsym}{a numeric parameter representing the higher asymptote
when \code{x} trend to \code{Inf}}

\item{xMid}{is the x value corresponding to the inflection point}

\item{Asymetry}{is a numeric parameter representing the asymetry around
the inflection point}
}
\value{
The value returned is a list containing the nonlinear function,
the self starter function and the parameter names.
}
\description{
This selfStart model evaluates the 5 parameters logistic
regression model and its gradient.
It has an \code{initial}
attribute that will evaluate initial estimates of the parameters
\code{hAsym}, \code{lAsym}, \code{Slope}, \code{xMid} and \code{Asymetry}
for a given set of data
Instead of the standard \code{exp} function this implementation use
the \code{10^} function.
\deqn{f(x)=lAsym +\frac{hAsym-lAsym}{(1+10^{Slope(x-xMid)})^{Asymetry}}}
}
\examples{
# Load data
data(ecdata)
data(mfidata)

# Select analyte FGF for plate 1
dat <- mfidata[mfidata$plate=="plate_1" & mfidata$analyte=="FGF",]

sdf <- data_selection(dat, ecdata)[[1]]

# SSl5
ig <- scluminex("plate_1",sdf$standard, sdf$background,
            lfct="SSl5",
            bkg="ignore",
            fmfi="mfi",
            verbose=FALSE)

summary(ig)
}
\author{
John Aponte <john.aponte@cresib.cat>
}
\keyword{datasets}

