% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulate.R
\name{evaluate}
\alias{evaluate}
\title{Function \code{evaluate}}
\usage{
evaluate(x, rules = NULL, wildcard = NULL, values = NULL, expand = TRUE)
}
\arguments{
\item{x}{argument data frame}

\item{rules}{Named list with wildcards as names and vectors of replacements
as values. This is a way to evaluate multiple wildcards at once.}

\item{wildcard}{character string to replace with elements of \code{values}.}

\item{values}{values to replace the wildcard in the drake instructions. Must be
the same length as \code{x$code} if \code{expand} is \code{TRUE}.}

\item{expand}{If \code{TRUE}, loop over \code{values} when evaluating the wildcard,
creating more rows in the output data frame. Otherwise, each occurance of the wildcard
is replaced with the next entry in the \code{values} vector, and the values are recycled.}
}
\value{
an evaluated data frame
}
\description{
Evaluates the wildcard placeholders of a data frame of \code{drake} instructions.
Use the \code{\link{help_drake}} function to get more help.
}
\details{
If \code{wildcard} and \code{values} are not \code{NULL}, the members of 
\code{values} will replace \code{wildcard} in the \code{code}
column of \code{x}. If the \code{rules} list is not \code{NULL}, \code{rules} readds precedence
over \code{wildcard} and \code{values}. In this case, the names of \code{rules}
act as wildcards, and each corresponding element of \code{rules} acts as a 
\code{values} argument in a recursive call to \code{evaluate}.
Use the \code{\link{help_drake}} function to get more help.
}
\seealso{
\code{\link{help_drake}}
}

