% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{new_cache}
\alias{new_cache}
\title{Function new_cache}
\usage{
new_cache(path = drake::default_cache_path(),
  type = drake::default_cache_type(),
  short_hash_algo = drake::default_short_hash_algo(),
  long_hash_algo = drake::default_long_hash_algo())
}
\arguments{
\item{path}{file path to the cache}

\item{type}{character scalar, type of the drake cache.
Must be among the list of supported caches
in \code{\link{cache_types}()}.}

\item{short_hash_algo}{short hash algorithm for the cache.
See \code{\link{default_short_hash_algo}()} and
\code{\link{make}()}}

\item{long_hash_algo}{long hash algorithm for the cache.
See \code{\link{default_long_hash_algo}()} and
\code{\link{make}()}}
}
\description{
Make a new drake cache.
}
\examples{
\dontrun{
cache1 <- new_cache() # Creates a new hidden '.drake' folder.
cache2 <- new_cache(path = "not_hidden", short_hash_algo = "md5")
}
}
\seealso{
\code{\link{default_short_hash_algo}},
\code{\link{default_long_hash_algo}},
\code{\link{make}}, \code{\link{cache_types}}
}
