% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{rescue_cache}
\alias{rescue_cache}
\title{Try to repair a drake cache that is prone
to throwing \code{storr}-related errors.}
\usage{
rescue_cache(targets = NULL, path = getwd(), search = TRUE, verbose = 1,
  force = FALSE, cache = drake::get_cache(path = path, search = search,
  verbose = verbose, force = force), jobs = 1, garbage_collection = FALSE)
}
\arguments{
\item{targets}{Character vector, names of the targets to rescue.
As with many other drake utility functions, the word \code{target}
is defined generally in this case, encompassing imports
as well as true targets.
If \code{targets} is \code{NULL}, everything in the
cache is rescued.}

\item{path}{same as for \code{\link{get_cache}()}}

\item{search}{same as for \code{\link{get_cache}()}}

\item{verbose}{same as for \code{\link{get_cache}()}}

\item{force}{same as for \code{\link{get_cache}()}}

\item{cache}{a `storr` cache object}

\item{jobs}{number of jobs for light parallelism
(disabled on Windows)}

\item{garbage_collection}{logical, whether to do garbage collection
as a final step. See \code{\link{drake_gc}} and \code{\link{clean}}
for details.}
}
\value{
The rescued drake/storr cache.
}
\description{
Sometimes, \code{storr} caches may have
dangling orphaned files that prevent you from loading or cleaning.
This function tries to remove those files so you can use the
cache normally again.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
make(my_plan) # Run the project, build targets. This creates the cache.
# Remove dangling cache files that could cause errors.
rescue_cache(jobs = 2)
# Alternatively, just rescue targets 'small' and 'large'.
# Rescuing specific targets is usually faster.
rescue_cache(targets = c("small", "large"))
})
}
}
\seealso{
\code{\link{get_cache}}, \code{\link{cached}},
\code{\link{drake_gc}}, \code{\link{clean}}
}
