% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workplan.R
\name{file_out}
\alias{file_out}
\title{Declare the file outputs of a workflow plan command.}
\usage{
file_out(path)
}
\arguments{
\item{path}{Character string of length 1. File path
of the file output of a command in your
workflow plan data frame.}

\item{...}{Do not use. For informative input handling only.}
}
\value{
A character string, the file path of the file output.
}
\description{
Use this function to help write the commands
in your workflow plan data frame. You can only specify
one file output per command. See the examples
for a full explanation.
}
\examples{
\dontrun{
test_with_dir("Contain side effects", {
# The `file_out()` and `file_in()` functions
# just takes in strings and returns them.
file_out("summaries.txt")
# Their main purpose is to orchestrate your custom files
# in your workflow plan data frame.
suppressWarnings(
  plan <- drake_plan(
    write.csv(mtcars, file_out("mtcars.csv")),
    contents = read.csv(file_in("mtcars.csv")),
    strings_in_dots = "literals" # deprecated but useful: no single quotes needed. # nolint
  )
)
plan
# Drake knows "\\"mtcars.csv\\"" is the first target
# and a dependency of `contents`. See for yourself:
config <- make(plan)
file.exists("mtcars.csv")
vis_drake_graph(config)
# See also `knitr_in()`. `knitr_in()` is like `file_in()`
# except that it analyzes active code chunks in your `knitr`
# source file and detects non-file dependencies.
# That way, updates to the right dependencies trigger rebuilds
# in your report.
})
}
}
\seealso{
\code{\link[=file_in]{file_in()}}, \code{\link[=knitr_in]{knitr_in()}}, \code{\link[=ignore]{ignore()}}
}
