% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.R
\name{default_long_hash_algo}
\alias{default_long_hash_algo}
\title{Return the default long hash algorithm for \code{make()}.}
\usage{
default_long_hash_algo(cache = NULL)
}
\arguments{
\item{cache}{optional drake cache.
When you \code{\link{configure_cache}(cache)} without
supplying a long hash algorithm,
\code{default_long_hash_algo(cache)} is the long
hash algorithm that drake picks for you.}
}
\value{
A character vector naming a hash algorithm.
}
\description{
See the advanced storage tutorial
at \url{https://ropenscilabs.github.io/drake-manual/store.html}
for details.
}
\details{
The long algorithm must be among \code{\link{available_hash_algos}{}},
which is just the collection of algorithms available to the \code{algo}
argument in \code{digest::digest()}. \cr \cr

If you express no preference for a hash, drake will use
the long hash for the existing project, or
\code{\link[=default_long_hash_algo]{default_long_hash_algo()}} for a new project.
If you do supply a hash algorithm, it will only apply to
fresh projects (see \code{\link{clean}(destroy = TRUE)}).
For a project that already exists, if you supply a hash algorithm,
drake will warn you and then ignore your choice, opting instead for
the hash algorithm already chosen for the project
in a previous \code{make()}. \cr \cr

Drake uses both a short hash algorithm
and a long hash algorithm. The shorter hash has fewer characters,
and it is used to generate the names of internal cache files
and auxiliary files. The decision for short names is important
because Windows places restrictions on the length of file paths.
On the other hand, some internal hashes in drake are
never used as file names, and those hashes can use a longer hash
to avoid collisions.
}
\examples{
default_long_hash_algo()
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
# Run the project and return the internal master configuration list.
config <- make(my_plan)
# Locate the storr cache.
cache <- config$cache
# Get the default long hash algorithm of an existing cache.
default_long_hash_algo(cache)
})
}
}
\seealso{
\code{\link[=make]{make()}}, \code{\link[=available_hash_algos]{available_hash_algos()}}
}
