% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{rescue_cache}
\alias{rescue_cache}
\title{Try to repair a drake cache that is prone
to throwing \code{storr}-related errors.}
\usage{
rescue_cache(targets = NULL, path = getwd(), search = TRUE,
  verbose = drake::default_verbose(), force = FALSE,
  cache = drake::get_cache(path = path, search = search, verbose = verbose,
  force = force), jobs = 1, garbage_collection = FALSE)
}
\arguments{
\item{targets}{Character vector, names of the targets to rescue.
As with many other drake utility functions, the word \code{target}
is defined generally in this case, encompassing imports
as well as true targets.
If \code{targets} is \code{NULL}, everything in the
cache is rescued.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\describe{
\item{0 or \code{FALSE}:}{print nothing.}
\item{1 or \code{TRUE}:}{print only targets to build.}
\item{2:}{in addition, print checks and cache info.}
\item{3:}{in addition, print any potentially missing items.}
\item{4:}{in addition, print imports. Full verbosity.}
}}

\item{force}{logical, whether to load the cache
despite any back compatibility issues with the
running version of drake.}

\item{cache}{a \code{storr} cache object}

\item{jobs}{number of jobs for light parallelism
(disabled on Windows)}

\item{garbage_collection}{logical, whether to do garbage collection
as a final step. See \code{\link[=drake_gc]{drake_gc()}} and \code{\link[=clean]{clean()}}
for details.}
}
\value{
The rescued drake/storr cache.
}
\description{
Sometimes, \code{storr} caches may have
dangling orphaned files that prevent you from loading or cleaning.
This function tries to remove those files so you can use the
cache normally again.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build targets. This creates the cache.
# Remove dangling cache files that could cause errors.
rescue_cache(jobs = 2)
# Alternatively, just rescue targets 'small' and 'large'.
# Rescuing specific targets is usually faster.
rescue_cache(targets = c("small", "large"))
})
}
}
\seealso{
\code{\link[=get_cache]{get_cache()}}, \code{\link[=cached]{cached()}},
\code{\link[=drake_gc]{drake_gc()}}, \code{\link[=clean]{clean()}}
}
