% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{drake_gc}
\alias{drake_gc}
\title{Do garbage collection on the drake cache.}
\usage{
drake_gc(path = getwd(), search = TRUE,
  verbose = drake::default_verbose(), cache = NULL, force = FALSE)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: also print checks and cache info.
\item \code{3}: also print any potentially missing items.
\item \code{4}: also print imports and writes to the cache.
}}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{force}{logical, whether to load the cache
despite any back compatibility issues with the
running version of drake.}
}
\value{
\code{NULL}
}
\description{
The cache is a key-value store.
By default, the \code{\link[=clean]{clean()}} function removes
values, but not keys.
Garbage collection removes the remaining dangling files.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
# At this point, check the size of the '.drake/' cache folder.
# Clean without garbage collection.
clean(garbage_collection = FALSE)
# The '.drake/' cache folder is still about the same size.
drake_gc() # Do garbage collection on the cache.
# The '.drake/' cache folder should have gotten much smaller.
})
}
}
\seealso{
\code{\link[=clean]{clean()}}
}
